<?php
// Incluir la conexión a la base de datos
include 'db_connection.php';

header('Content-Type: application/json');

// Validar que los datos se recibieron por POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Método no permitido.']);
    exit;
}

// Recibir y validar los datos
$id_producto = isset($_POST['id_producto']) ? intval($_POST['id_producto']) : 0;
$exento_iva = isset($_POST['exento_iva']) ? intval($_POST['exento_iva']) : 0;

if ($id_producto <= 0) {
    echo json_encode(['success' => false, 'message' => 'ID de producto inválido.']);
    exit;
}

// Preparar la consulta para actualizar el campo 'exento_iva'
$sql = "UPDATE productos SET exento_iva = ? WHERE id = ?";
$stmt = $conn->prepare($sql);

if ($stmt === false) {
    echo json_encode(['success' => false, 'message' => 'Error al preparar la consulta.']);
    exit;
}

// Vincular parámetros (el nuevo valor de exento_iva y el ID del producto)
$stmt->bind_param("ii", $exento_iva, $id_producto);

// Ejecutar y verificar
if ($stmt->execute()) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Error al ejecutar la actualización: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
?>