<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de IVA y Precios por Producto</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .container-fluid { /* Cambiado a container-fluid */
            padding-right: var(--bs-gutter-x,.75rem);
            padding-left: var(--bs-gutter-x,.75rem);
            margin-right: auto;
            margin-left: auto;
        }
        .card { margin-top: 20px; }
        .form-check-input:checked {
            background-color: #198754; /* Verde */
            border-color: #198754;
        }
        .form-check-input, .price-input {
             cursor: pointer;
        }
        .form-label b {
            font-size: 0.9em;
        }
        .price-input {
            width: 70px; /* Reducido el ancho del input de precio */
            padding: 0.25rem;
            font-size: 0.8em; /* Reducido el tamaño de la fuente para que quepan más */
        }
        th, td {
            white-space: nowrap;
            font-size: 0.9em; /* Ajuste para que las celdas sean más compactas */
            padding: 0.5rem;
        }
        .table-responsive {
            overflow-x: hidden; /* Oculta el scroll horizontal */
        }
    </style>
</head>
<body>
    <div class="container-fluid my-4"> <div class="card shadow-sm">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0">Actualizar IVA y Precios de Productos</h4>
            </div>
            <div class="card-body">
                <form method="GET" action="">
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label for="laboratorio" class="form-label"><b>Laboratorio:</b></label>
                            <input type="text" class="form-control" id="laboratorio" name="laboratorio" placeholder="Filtrar por laboratorio" value="<?php echo isset($_GET['laboratorio']) ? htmlspecialchars($_GET['laboratorio']) : ''; ?>">
                        </div>
                        <div class="col-md-3">
                            <label for="nombre" class="form-label"><b>Nombre Comercial:</b></label>
                            <input type="text" class="form-control" id="nombre" name="nombre" placeholder="Filtrar por nombre" value="<?php echo isset($_GET['nombre']) ? htmlspecialchars($_GET['nombre']) : ''; ?>">
                        </div>
                        <div class="col-md-3">
                             <label for="codigo" class="form-label"><b>Código Interno:</b></label>
                            <input type="text" class="form-control" id="codigo" name="codigo" placeholder="Filtrar por código" value="<?php echo isset($_GET['codigo']) ? htmlspecialchars($_GET['codigo']) : ''; ?>">
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <button class="btn btn-primary w-100" type="submit">Buscar Productos</button>
                        </div>
                    </div>
                </form>

                <?php
                // Procesar la búsqueda si se envió al menos un filtro
                if (!empty($_GET['laboratorio']) || !empty($_GET['nombre']) || !empty($_GET['codigo'])) {
                    include 'db_connection.php'; // Incluye tu archivo de conexión

                    // --- CONSTRUCCIÓN DE CONSULTA DINÁMICA ---
                    $sql_base = "SELECT id, NombreComercial, CodigoInterno, Laboratorio, exento_iva, CostoMayor, CostoBlister, CostoUnidad, CostoMixto, PrecioVentaUnidad, PrecioVentaBlister, PrecioVentaMayor, PrecioVentaMixto FROM productos WHERE 1=1";
                    $params = [];
                    $types = '';

                    if (!empty($_GET['laboratorio'])) {
                        $sql_base .= " AND Laboratorio LIKE ?";
                        $params[] = '%' . $_GET['laboratorio'] . '%';
                        $types .= 's';
                    }
                    if (!empty($_GET['nombre'])) {
                        $sql_base .= " AND NombreComercial LIKE ?";
                        $params[] = '%' . $_GET['nombre'] . '%';
                        $types .= 's';
                    }
                    if (!empty($_GET['codigo'])) {
                        $sql_base .= " AND CodigoInterno LIKE ?";
                        $params[] = '%' . $_GET['codigo'] . '%';
                        $types .= 's';
                    }
                    
                    $sql_base .= " ORDER BY NombreComercial ASC"; // Ordenar alfabéticamente

                    $stmt = $conn->prepare($sql_base);
                    if ($types) { // Solo vincular parámetros si hay alguno
                        $stmt->bind_param($types, ...$params);
                    }
                    $stmt->execute();
                    $result = $stmt->get_result();

                    if ($result->num_rows > 0) {
                        echo '<hr/><div class="alert alert-success">Mostrando ' . $result->num_rows . ' productos.</div>';
                        echo '<div class="table-responsive">';
                        echo '<table class="table table-striped table-hover table-sm">';
                        echo '<thead class="table-dark"><tr><th>Producto</th><th>Laboratorio</th><th>Código</th><th class="text-center">Exento IVA</th><th>Costo Mayor</th><th>Costo Blister</th><th>Costo Unidad</th><th>Costo Mixto</th><th>Venta Unidad</th><th>Venta Blister</th><th>Venta Mayor</th><th>Venta Mixto</th></tr></thead>';
                        echo '<tbody>';
                        while ($row = $result->fetch_assoc()) {
                            $checked = $row['exento_iva'] ? 'checked' : '';
                            echo '<tr data-id="' . $row['id'] . '">';
                            echo '<td>' . htmlspecialchars($row['NombreComercial']) . '</td>';
                            echo '<td>' . htmlspecialchars($row['Laboratorio']) . '</td>';
                            echo '<td>' . htmlspecialchars($row['CodigoInterno']) . '</td>';
                            echo '<td class="text-center">';
                            echo '<div class="form-check form-switch d-inline-block">';
                            echo '<input class="form-check-input exento_iva_switch" type="checkbox" role="switch" data-id="' . $row['id'] . '" ' . $checked . '>';
                            echo '</div>';
                            echo '</td>';
                            echo '<td><input type="number" step="0.01" class="form-control price-input" data-field="CostoMayor" value="' . htmlspecialchars($row['CostoMayor']) . '"></td>';
                            echo '<td><input type="number" step="0.01" class="form-control price-input" data-field="CostoBlister" value="' . htmlspecialchars($row['CostoBlister']) . '"></td>';
                            echo '<td><input type="number" step="0.01" class="form-control price-input" data-field="CostoUnidad" value="' . htmlspecialchars($row['CostoUnidad']) . '"></td>';
                            echo '<td><input type="number" step="0.01" class="form-control price-input" data-field="CostoMixto" value="' . htmlspecialchars($row['CostoMixto']) . '"></td>';
                            echo '<td><input type="number" step="0.01" class="form-control price-input" data-field="PrecioVentaUnidad" value="' . htmlspecialchars($row['PrecioVentaUnidad']) . '"></td>';
                            echo '<td><input type="number" step="0.01" class="form-control price-input" data-field="PrecioVentaBlister" value="' . htmlspecialchars($row['PrecioVentaBlister']) . '"></td>';
                            echo '<td><input type="number" step="0.01" class="form-control price-input" data-field="PrecioVentaMayor" value="' . htmlspecialchars($row['PrecioVentaMayor']) . '"></td>';
                            echo '<td><input type="number" step="0.01" class="form-control price-input" data-field="PrecioVentaMixto" value="' . htmlspecialchars($row['PrecioVentaMixto']) . '"></td>';
                            echo '</tr>';
                        }
                        echo '</tbody></table>';
                        echo '</div>'; // Cierre del div .table-responsive
                    } else {
                        echo '<hr/><div class="alert alert-warning mt-3">No se encontraron productos con los filtros especificados.</div>';
                    }
                    $stmt->close();
                    $conn->close();
                }
                ?>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>
    <script>
    $(document).ready(function() {
        // Lógica para actualizar el IVA (ya existente)
        $('.exento_iva_switch').on('change', function() {
            var productId = $(this).data('id');
            var isChecked = $(this).is(':checked') ? 1 : 0;
            var switchElement = $(this);

            switchElement.prop('disabled', true);

            $.ajax({
                url: 'actualizar_iva.php',
                type: 'POST',
                data: {
                    id_producto: productId,
                    exento_iva: isChecked
                },
                dataType: 'json',
                success: function(response) {
                    if (!response.success) {
                        alert('Error al actualizar el producto: ' + response.message);
                        switchElement.prop('checked', !isChecked);
                    }
                },
                error: function() {
                    alert('Error de conexión. No se pudo guardar el cambio.');
                    switchElement.prop('checked', !isChecked);
                },
                complete: function() {
                    switchElement.prop('disabled', false);
                }
            });
        });

        // Lógica para actualizar los precios
        $('.price-input').on('blur', function() {
            var inputElement = $(this);
            var productId = inputElement.closest('tr').data('id');
            var field = inputElement.data('field');
            var value = inputElement.val();
            
            // Validar que el valor sea un número y no esté vacío
            if (value === '' || isNaN(value)) {
                return; // No hacer nada si el valor no es un número
            }
            
            // Si el valor no ha cambiado, no hacer nada
            var originalValue = parseFloat(inputElement.data('original-value'));
            if (value == originalValue) {
                return;
            }

            $.ajax({
                url: 'actualizar_precio.php', // Nuevo archivo para manejar precios
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify({
                    id: productId,
                    field: field,
                    value: value
                }),
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        console.log('Precio actualizado correctamente.');
                    } else {
                        alert('Error al actualizar el precio: ' + response.message);
                    }
                },
                error: function() {
                    alert('Error de conexión al actualizar el precio.');
                }
            });
        });

        // Guardar el valor original al enfocar para la comparación
        $('.price-input').on('focus', function() {
            $(this).data('original-value', $(this).val());
        });
    });
    </script>
</body>
</html>