<?php
// Usamos la configuración para el ID y ahora también para el NOMBRE
require_once 'php/config.php';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ver Ingresos - Sufarma v3</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="icon" href="data:image/svg+xml,<svg xmlns=%22http://www.w3.org/2000/svg%22 viewBox=%220 0 100 100%22><text y=%22.9em%22 font-size=%2290%22>📋</text></svg>">
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-success shadow-sm">
    <div class="container">
        <a class="navbar-brand" href="#">Sufarma v3</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link active" aria-current="page" href="index.php">Registrar Ingreso</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="ingresos.php">Ver Ingresos</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="index.php">recargar pagina</a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<div class="container my-4">
    <div class="card shadow-sm mt-4">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">Historial de Ingresos (<?php echo NOMBRE_SUCURSAL_ACTUAL; ?>)</h4>
        </div>
        <div class="card-body">
            <div class="table-responsive" style="max-height: 600px; overflow-y: auto;">
                <table class="table table-sm table-striped table-hover">
                    <thead class="table-light sticky-top">
                        <tr>
                            <th>Producto / Laboratorio</th>
                            <th>Cantidad</th>
                            <th>Presentación</th>
                            <th>Vencimiento</th>
                            <th>Facturable</th>      <th>Fecha Ingreso</th>
                            <th>Entregado Por</th>   <th>Registrado Por</th>
                        </tr>
                    </thead>
                    <tbody id="tabla_ingresos_recientes">
                        <tr><td colspan="8" class="text-center text-muted">Cargando ingresos...</td></tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="js/ingresos.js"></script>

</body>
</html>