<?php
// --- CONFIGURACIÓN DE LA BASE DE DATOS ---
define('DB_HOST', 'localhost');
define('DB_USER', 'farmacia_onlydi2025');
define('DB_PASS', '1corintios13'); // Sin contraseña, como solicitaste
define('DB_NAME', 'farmacia_sufarma2025');

// --- CONFIGURACIÓN DE LA SUCURSAL ---
// Este es el ID de la sucursal actual.
define('ID_SUCURSAL_ACTUAL', 1); // Asegúrate que una sucursal con id=1 exista.

// Crear la conexión a la base de datos usando PDO
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4", DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    // Detener la ejecución si la conexión falla
    die("ERROR: No se pudo conectar a la base de datos. " . $e->getMessage());
}

// --- OBTENER NOMBRE DE LA SUCURSAL ---
try {
    $sql_sucursal = "SELECT nombre FROM sucursales WHERE id = ?";
    $stmt_sucursal = $pdo->prepare($sql_sucursal);
    $stmt_sucursal->execute([ID_SUCURSAL_ACTUAL]);
    $sucursal = $stmt_sucursal->fetch(PDO::FETCH_ASSOC);

    if ($sucursal) {
        define('NOMBRE_SUCURSAL_ACTUAL', $sucursal['nombre']);
    } else {
        define('NOMBRE_SUCURSAL_ACTUAL', 'Sucursal Desconocida');
    }
} catch (PDOException $e) {
    // Si hay un error de BD, definimos un nombre de respaldo
    define('NOMBRE_SUCURSAL_ACTUAL', 'Error al cargar sucursal');
}


// Función para obtener todos los usuarios (para los selectores de entrega/recibe)
function obtenerUsuarios($pdo) {
    $stmt = $pdo->query("SELECT id, nombre FROM usuarios ORDER BY nombre ASC");
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}


// --- Obtiene solo los usuarios autorizados para ENTREGAR ---
function obtenerUsuariosEntrega($pdo) {
    $sql = "SELECT id, nombre FROM usuarios WHERE id IN (1, 12, 13) ORDER BY nombre ASC";
    $stmt = $pdo->query($sql);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// --- Obtiene los usuarios autorizados para RECIBIR ---
function obtenerUsuariosRecibe($pdo) {
    $ids = [];

    switch (ID_SUCURSAL_ACTUAL) {
        case 2:
            $ids = [7, 8, 10];
            break;
        case 3:
            $ids = [5, 6, 11];
            break;
        case 4:
            $ids = [9];
            break;
        case 5:
            $ids = [3, 4, 11];
            break;
        // Sucursal 1 usará la lógica de respaldo (else)
    }

    if (!empty($ids)) {
        $id_list = implode(',', array_map('intval', $ids));
        $sql = "SELECT id, nombre FROM usuarios WHERE id IN ($id_list) ORDER BY nombre ASC";
    } else {
        // Lógica de respaldo: Si la sucursal no está en el switch (ej. Sucursal 1),
        // simplemente mostramos todos los usuarios.
        $sql = "SELECT id, nombre FROM usuarios ORDER BY nombre ASC";
    }

    $stmt = $pdo->query($sql);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// =============================================
//          AQUÍ ESTÁ LA FUNCIÓN FALTANTE
// =============================================
/**
 * Obtiene todas las sucursales EXCEPTO la actual.
 * (Para el dropdown de "Destino")
 */
function obtenerSucursalesDestino($pdo) {
    // Seleccionamos todas las sucursales donde el ID no sea el de la sucursal actual
    $sql = "SELECT id, nombre FROM sucursales WHERE id != ? ORDER BY nombre ASC";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([ID_SUCURSAL_ACTUAL]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

?>