<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>CRUD Productos</title>

  <!-- Cargar Google Fonts: Open Sans -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link 
    href="https://fonts.googleapis.com/css2?family=Open+Sans&display=swap" 
    rel="stylesheet"
  >

  <!-- Bootstrap CSS -->
  <link 
    rel="stylesheet" 
    href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css"
  >

  <!-- Nuestro CSS adicional -->
  <link rel="stylesheet" href="assets/css/styles.css">
</head>
<body class="bg-light">

<div class="container-fluid mt-4 mb-5">

  <h1 class="text-center mb-4">Gestión de Productos</h1>

  <!-- FILTROS (buscador + orden) -->
  <div class="row mb-3">
    <div class="col-md-4">
      <input 
        type="text" 
        class="form-control" 
        id="searchInput" 
        placeholder="Buscar (código, comercial, genérico)..."
      >
    </div>
    <div class="col-md-3">
      <select class="form-select" id="orderSelect">
        <option value="ASC">Ordenar Código (Asc)</option>
        <option value="DESC">Ordenar Código (Desc)</option>
      </select>
    </div>
    <div class="col-md-2 d-none">
      <!-- Botón de búsqueda oculto: búsqueda dinámica con input-->
      <button 
        class="btn btn-primary w-100" 
        id="btnBuscar"
      >Buscar</button>
    </div>
    <div class="col-md-3 text-end">
      <button 
        class="btn btn-success" 
        data-bs-toggle="modal" 
        data-bs-target="#modalNuevoProducto"
      >Nuevo Producto</button>
    </div>
  </div>

  <!-- TABLA -->
  <div class="table-responsive">
    <table class="table table-striped align-middle" id="productosTable">
      <thead>
        <tr>
          <th scope="col">Código Interno</th>
          <th scope="col">Código Barra</th>
          <th scope="col">Nombre Comercial</th>
          <th scope="col">Nombre Genérico</th>
          <th scope="col">Categoría ID</th>
          <th scope="col">Función Médica</th>
          <th scope="col">Laboratorio</th>
          <th scope="col">LugarCompra ID</th>
          <th scope="col">Costo Mayor</th>
          <th scope="col">Costo Blister</th>
          <th scope="col">Costo Unidad</th>
          <th scope="col">Costo Mixto</th>
          <th scope="col">P.V. Unidad</th>
          <th scope="col">P.V. Blister</th>
          <th scope="col">P.V. Mayor</th>
          <th scope="col">P.V. Mixto</th>
          <th scope="col">F. Ingreso</th>
          <th scope="col">F. Venc.</th>
          <th scope="col">Presentación ID</th>
          <th scope="col">Estado</th>
          <th scope="col">Factor Conversion</th>
          <th scope="col">Imagen (Hover)</th>
          <th scope="col">Acciones</th> <!-- NUEVA COLUMNA -->
        </tr>
      </thead>
      <tbody id="productosBody">
        <!-- Se cargará por AJAX -->
      </tbody>
    </table>
  </div>

  <!-- Paginación -->
  <nav>
    <ul class="pagination justify-content-center" id="paginationUl">
      <!-- Generado por script.js -->
    </ul>
  </nav>

</div> <!-- container -->


<!-- MODAL NUEVO PRODUCTO -->
<div class="modal fade" id="modalNuevoProducto" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form id="formNuevoProducto">
        <div class="modal-header">
          <h5 class="modal-title">Crear Nuevo Producto</h5>
          <button 
            type="button" 
            class="btn-close" 
            data-bs-dismiss="modal" 
            aria-label="Close"
          ></button>
        </div>
        <div class="modal-body">
          
          <div class="row g-3">
            <div class="col-md-4">
              <label class="form-label">Código Interno</label>
              <input type="text" class="form-control" name="CodigoInterno">
            </div>
            <div class="col-md-4">
              <label class="form-label">Código Barra</label>
              <input type="text" class="form-control" name="CodigoBarra">
            </div>
            <div class="col-md-4">
              <label class="form-label">Nombre Comercial</label>
              <input type="text" class="form-control" name="NombreComercial">
            </div>
            <div class="col-md-6">
              <label class="form-label">Nombre Genérico</label>
              <input type="text" class="form-control" name="NombreGenerico">
            </div>
            <div class="col-md-6">
              <label class="form-label">ID Categoría</label>
              <input type="number" class="form-control" name="id_categoria">
            </div>
            <div class="col-md-6">
              <label class="form-label">Función Médica</label>
              <textarea class="form-control" name="FuncionMedica"></textarea>
            </div>
            <div class="col-md-6">
              <label class="form-label">Laboratorio</label>
              <input type="text" class="form-control" name="laboratorio">
            </div>
            <div class="col-md-4">
              <label class="form-label">ID Lugar Compra</label>
              <input type="number" class="form-control" name="id_lugarCompra">
            </div>
            <div class="col-md-4">
              <label class="form-label">Costo Mayor</label>
              <input type="number" step="any" class="form-control" name="CostoMayor">
            </div>
            <div class="col-md-4">
              <label class="form-label">Costo Blister</label>
              <input type="number" step="any" class="form-control" name="CostoBlister">
            </div>
            <div class="col-md-4">
              <label class="form-label">Costo Unidad</label>
              <input type="number" step="any" class="form-control" name="CostoUnidad">
            </div>
            <div class="col-md-4">
              <label class="form-label">Costo Mixto</label>
              <input type="number" step="any" class="form-control" name="CostoMixto">
            </div>
            <div class="col-md-4">
              <label class="form-label">P.V. Unidad</label>
              <input type="number" step="any" class="form-control" name="PrecioVentaUnidad">
            </div>
            <div class="col-md-4">
              <label class="form-label">P.V. Blister</label>
              <input type="number" step="any" class="form-control" name="PrecioVentaBlister">
            </div>
            <div class="col-md-4">
              <label class="form-label">P.V. Mayor</label>
              <input type="number" step="any" class="form-control" name="PrecioVentaMayor">
            </div>
            <div class="col-md-4">
              <label class="form-label">P.V. Mixto</label>
              <input type="number" step="any" class="form-control" name="PrecioVentaMixto">
            </div>
            <div class="col-md-6">
              <label class="form-label">Fecha Ingreso</label>
              <input type="date" class="form-control" name="FechaIngreso">
            </div>
            <div class="col-md-6">
              <label class="form-label">Fecha Venc.</label>
              <input type="date" class="form-control" name="FechaVencimiento">
            </div>
            <div class="col-md-4">
              <label class="form-label">ID Presentación</label>
              <input type="number" class="form-control" name="id_presentacion">
            </div>
            <div class="col-md-4">
              <label class="form-label">Estado</label>
              <select class="form-select" name="estado">
                <option value="1" selected>Activo (1)</option>
                <option value="0">Inactivo (0)</option>
              </select>
            </div>
            <div class="col-md-4">
              <label class="form-label">Factor Conversión</label>
              <input type="number" class="form-control" name="factor_conversion" value="1">
            </div>
            <div class="col-md-12">
              <label class="form-label">Imagen Producto</label>
              <input type="file" class="form-control" name="imagen_producto">
            </div>
          </div>

        </div>
        <div class="modal-footer">
          <button 
            type="button" 
            class="btn btn-secondary" 
            data-bs-dismiss="modal"
          >Cerrar</button>
          <button 
            type="submit" 
            class="btn btn-primary"
          >Guardar</button>
        </div>
      </form>
    </div>
  </div>
</div>


<!-- Bootstrap JS (Requiere Popper) -->
<script 
  src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"
></script>

<!-- Nuestro script -->
<script src="assets/js/script.js"></script>

</body>
</html>
