<?php
require_once 'config.php';

// Función para obtener las sucursales
function getSucursales() {
    global $pdo;
    $stmt = $pdo->query('SELECT id, nombre FROM sucursales ORDER BY nombre');
    return $stmt->fetchAll();
}

// Función para obtener los detalles de ventas facturadas
function getDetallesVentas($fecha_inicio, $fecha_fin, $sucursal_id) {
    global $pdo;
    
    $sql = "SELECT 
                v.fecha_y_hora,
                s.nombre as sucursal,
                p.NombreComercial as producto,
                dv.cantidad,
                dv.precio,
                dv.subtotal
            FROM detalle_ventas dv
            INNER JOIN ventas v ON dv.venta_id = v.id
            INNER JOIN productos p ON dv.producto_id = p.id
            INNER JOIN sucursales s ON v.sucursal_id = s.id
            WHERE dv.facturado = 1";
    
    $params = [];
    
    if ($fecha_inicio) {
        $sql .= " AND DATE(v.fecha_y_hora) >= ?";
        $params[] = $fecha_inicio;
    }
    
    if ($fecha_fin) {
        $sql .= " AND DATE(v.fecha_y_hora) <= ?";
        $params[] = $fecha_fin;
    }
    
    if ($sucursal_id) {
        $sql .= " AND v.sucursal_id = ?";
        $params[] = $sucursal_id;
    }
    
    $sql .= " ORDER BY v.fecha_y_hora DESC";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    return $stmt->fetchAll();
}

// Procesar la solicitud AJAX
$action = $_GET['action'] ?? '';

header('Content-Type: application/json');

switch ($action) {
    case 'getSucursales':
        echo json_encode(getSucursales());
        break;
        
    case 'getVentas':
        $fecha_inicio = $_GET['fecha_inicio'] ?? null;
        $fecha_fin = $_GET['fecha_fin'] ?? null;
        $sucursal_id = $_GET['sucursal_id'] ?? null;
        
        echo json_encode(getDetallesVentas($fecha_inicio, $fecha_fin, $sucursal_id));
        break;
        
    default:
        echo json_encode(['error' => 'Acción no válida']);
        break;
}