$(document).ready(function() {
    // Inicializar DataTable
    let tabla = $('#tablaVentas').DataTable({
        language: {
            url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json'
        },
        pageLength: 10,
        responsive: true,
        columns: [
            { data: 'fecha_y_hora' },
            { data: 'sucursal' },
            { data: 'producto' },
            { data: 'cantidad' },
            { data: 'precio' },
            { data: 'subtotal' }
        ]
    });

    // Cargar sucursales al inicio
    $.get('get_data.php', { action: 'getSucursales' }, function(data) {
        let select = $('#sucursal');
        data.forEach(function(sucursal) {
            select.append(`<option value="${sucursal.id}">${sucursal.nombre}</option>`);
        });
    });

    // Función para cargar los datos de ventas
    function cargarVentas() {
        let fecha_inicio = $('#fecha_inicio').val();
        let fecha_fin = $('#fecha_fin').val();
        let sucursal_id = $('#sucursal').val();

        $.get('get_data.php', {
            action: 'getVentas',
            fecha_inicio: fecha_inicio,
            fecha_fin: fecha_fin,
            sucursal_id: sucursal_id
        }, function(data) {
            tabla.clear();
            tabla.rows.add(data);
            tabla.draw();
        });
    }

    // Manejar envío del formulario
    $('#filtroForm').on('submit', function(e) {
        e.preventDefault();
        cargarVentas();
    });

    // Cargar datos iniciales
    cargarVentas();
});