<?php
require 'db.php';

$data = json_decode(file_get_contents('php://input'), true);

$response = ['status' => 'error', 'message' => 'Error desconocido.'];

if (isset($data['producto_id'], $data['categoria_id'])) {
    
    $productId = (int)$data['producto_id'];
    // Si el valor es "0", lo guardamos como NULL en la BD
    $categoryId = (int)$data['categoria_id'] > 0 ? (int)$data['categoria_id'] : NULL;

    try {
        // Esta es la consulta clave: actualiza la columna 'id_categoria'
        $sql = "UPDATE productos SET id_categoria = ? WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$categoryId, $productId]);
        
        if ($stmt->rowCount() > 0) {
            $response = ['status' => 'success', 'message' => 'Categoría actualizada.'];
        } else {
            // Esto puede pasar si el usuario vuelve a seleccionar la misma categoría
            $response = ['status' => 'success', 'message' => 'Sin cambios.'];
        }

    } catch (PDOException $e) {
        $response['message'] = 'Error de base de datos: ' . $e->getMessage();
    }
} else {
    $response['message'] = 'Datos incompletos.';
}

// Devolvemos una respuesta JSON
header('Content-Type: application/json');
echo json_encode($response);
?>