<!-- Titulo y Botón para Nuevo Producto -->
<div class="d-flex justify-content-between align-items-center mb-3">
    <h2>Gestión de Productos</h2>
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addProductModal">
        <i class="fas fa-plus"></i> Ingresar Nuevo Producto
    </button>
</div>

<!-- Formulario de Búsqueda Dinámico -->
<div class="card mb-4">
    <div class="card-header">
        <i class="fas fa-search"></i> Búsqueda Dinámica
    </div>
    <div class="card-body">
        <form id="search-form">
            <div class="row">
                <div class="col-md-12">
                    <input type="text" id="search-term" class="form-control" placeholder="Escribe para buscar por Códigos, Nombre, Genérico o Laboratorio...">
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Tabla de Productos -->
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped table-hover table-sm">
                <thead>
                    <tr>
                        <th>Códigos</th>
                        <th>Nombre Comercial</th>
                        <th>Nombre Genérico</th>
                        <th>Laboratorio</th>
                        <th>Costo Unidad</th>
                        <th>Costo Blister</th>
                        <th>Costo Mayor</th>
                        <th>Costo Mixto</th>
                        <th>P. Venta Unidad</th>
                        <th>P. Venta Blister</th>
                        <th>P. Venta Mayor</th>
                        <th>P. Venta Mixto</th>
                        <th>Fecha Ingreso</th>
                        <th>Fecha Vencimiento</th>
                        <th>Existencia</th>
                        <th>Exento IVA</th>
                    </tr>
                </thead>
                <tbody id="products-table-body">
                    <!-- Los productos se cargarán aquí vía AJAX -->
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer d-flex justify-content-between align-items-center">
        <div id="table-info"></div>
        <nav id="pagination"></nav>
    </div>
</div>

<!-- Modal para Ingresar Nuevo Producto (sin cambios) -->
<div class="modal fade" id="addProductModal" tabindex="-1" aria-labelledby="addProductModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addProductModalLabel">Ingresar Nuevo Producto</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="add-product-form">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="NombreComercial" class="form-label">Nombre Comercial</label>
                            <input type="text" class="form-control" id="NombreComercial" name="NombreComercial" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="NombreGenerico" class="form-label">Nombre Genérico</label>
                            <input type="text" class="form-control" id="NombreGenerico" name="NombreGenerico">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="CodigoInterno" class="form-label">Código Interno</label>
                            <input type="text" class="form-control" id="CodigoInterno" name="CodigoInterno">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="CodigoBarra" class="form-label">Código de Barra</label>
                            <input type="text" class="form-control" id="CodigoBarra" name="CodigoBarra">
                        </div>
                    </div>
                     <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="laboratorio" class="form-label">Laboratorio</label>
                            <input type="text" class="form-control" id="laboratorio" name="laboratorio">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="existencia" class="form-label">Existencia</label>
                            <input type="number" class="form-control" id="existencia" name="existencia" value="0">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="FechaVencimiento" class="form-label">Fecha de Vencimiento</label>
                            <input type="date" class="form-control" id="FechaVencimiento" name="FechaVencimiento">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                        <button type="submit" class="btn btn-primary">Guardar Producto</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
