-- Migration para Sistema de Pedidos de Medicamentos
-- Fecha: 2025-11-24

USE `sufarma`;

-- --------------------------------------------------------
-- Tabla principal de pedidos
-- --------------------------------------------------------

DROP TABLE IF EXISTS `detalle_pedidos`;
DROP TABLE IF EXISTS `pedidos`;

CREATE TABLE IF NOT EXISTS `pedidos` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `sucursal_id` int NOT NULL COMMENT 'Sucursal que realiza el pedido',
  `usuario_id` int NOT NULL COMMENT 'Usuario que crea el pedido',
  `fecha_pedido` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `estado` enum('pendiente','aprobado','enviado','completado','cancelado') NOT NULL DEFAULT 'pendiente',
  `observaciones` text,
  `fecha_actualizacion` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_sucursal` (`sucursal_id`),
  KEY `idx_usuario` (`usuario_id`),
  KEY `idx_fecha` (`fecha_pedido`),
  KEY `idx_estado` (`estado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Pedidos de medicamentos por sucursal';

-- --------------------------------------------------------
-- Tabla de detalles de pedidos
-- --------------------------------------------------------

CREATE TABLE IF NOT EXISTS `detalle_pedidos` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint UNSIGNED NOT NULL COMMENT 'Referencia al pedido',
  `producto_id` bigint UNSIGNED NOT NULL COMMENT 'Producto solicitado',
  `codigo_interno` varchar(50) DEFAULT NULL,
  `codigo_barra` varchar(50) DEFAULT NULL,
  `nombre_comercial` varchar(255) NOT NULL,
  `laboratorio` varchar(255) DEFAULT NULL,
  `es_urgente` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0=Normal, 1=Urgente',
  `existencia_actual` int NOT NULL DEFAULT '0' COMMENT 'Cantidad que tiene actualmente',
  `presentacion_actual` enum('UNIDAD','BLISTER','CAJA','BOTE','PAQUETE','FARDO','BOLSA','GALON') NOT NULL DEFAULT 'UNIDAD',
  `cantidad_solicitada` int NOT NULL COMMENT 'Cantidad que necesita',
  `presentacion_solicitada` enum('UNIDAD','BLISTER','CAJA','BOTE','PAQUETE','FARDO','BOLSA','GALON') NOT NULL DEFAULT 'UNIDAD',
  `cantidad_aprobada` int DEFAULT NULL COMMENT 'Cantidad aprobada por administrador',
  `cantidad_enviada` int DEFAULT NULL COMMENT 'Cantidad realmente enviada',
  `fecha_creacion` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_pedido` (`pedido_id`),
  KEY `idx_producto` (`producto_id`),
  KEY `idx_urgente` (`es_urgente`),
  CONSTRAINT `fk_detalle_pedido` FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Detalle de productos en cada pedido';

-- --------------------------------------------------------
-- Índices adicionales para optimización
-- --------------------------------------------------------

ALTER TABLE `detalle_pedidos`
  ADD INDEX `idx_codigo_interno` (`codigo_interno`),
  ADD INDEX `idx_codigo_barra` (`codigo_barra`);

COMMIT;
