<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard de Farmacia</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>

    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container-fluid">
            <a class="navbar-brand" href="#"><i class="fas fa-clinic-medical"></i> Farmacia Sufarma</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav">
                    <li class="nav-item">

                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo (isset($_GET['view']) && $_GET['view'] == 'conteo') ? 'active' : ''; ?>" href="?view=conteo"><i class="fas fa-boxes"></i> Conteo</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo (isset($_GET['view']) && $_GET['view'] == 'inventory_report') ? 'active' : ''; ?>" href="?view=inventory_report"><i class="fas fa-file-alt"></i> Reporte de Inventario</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <main class="container mt-4">
        <?php
        $view = isset($_GET['view']) ? $_GET['view'] : 'products';
        switch ($view) {
            case 'products':
                include 'views/products.php';
                break;
            case 'conteo':
                include 'views/conteo.php';
                break;
            case 'inventory_report':
                include 'views/inventory_report.php';
                break;
            default:
                include 'views/products.php'; // Default view
                break;
        }
        ?>
    </main>

    <!-- Bootstrap JS Bundle (incluye Popper) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <!-- Custom JS -->
    <?php if (!isset($_GET['view']) || $_GET['view'] == 'products'): ?>
        <script src="assets/js/products.js"></script>
    <?php elseif ($_GET['view'] == 'conteo'): ?>
        <script src="assets/js/inventory.js"></script>
    <?php elseif ($_GET['view'] == 'inventory_report'): ?>
        <script src="assets/js/inventory_report.js"></script>
    <?php elseif ($_GET['view'] == 'transfer'): ?>
        <script src="assets/js/transfer.js"></script>
    <?php endif; ?>
</body>
</html>