<?php
// ajax/filtrar_inventario.php

// Incluir la conexión a la base de datos
require_once '../config/db.php';

// --- RECOGER Y SANITIZAR LOS DATOS DEL FILTRO ---
$sucursal_id = isset($_POST['sucursal_id']) ? $_POST['sucursal_id'] : '';
$fecha_inicio = isset($_POST['fecha_inicio']) ? $_POST['fecha_inicio'] : '';
$fecha_fin = isset($_POST['fecha_fin']) ? $_POST['fecha_fin'] : '';

// --- CONSTRUIR LA CONSULTA SQL BASE ---
$sql = "
    SELECT 
        p.NombreComercial,
        p.CostoUnidad,
        l.codigo_lote,
        DATE_FORMAT(l.fechacreacion, '%d-%m-%Y') as fechacreacion_formateada,
        DATE_FORMAT(l.fechavencimiento, '%d-%m-%Y') as fechavencimiento_formateada,
        s.nombre as nombre_sucursal,
        i.stock_unidad_base,
        i.presentacion,
        (p.CostoUnidad * i.stock_unidad_base) AS CostoTotal
    FROM inventario i
    JOIN lote l ON i.lote_id = l.id
    JOIN productos p ON l.producto_id = p.id
    JOIN sucursales s ON i.sucursal_id = s.id
    WHERE 1=1
";

// --- AÑADIR CONDICIONES DE FILTRO DE FORMA SEGURA USANDO SENTENCIAS PREPARADAS ---
$params = [];
$types = '';

if (!empty($sucursal_id)) {
    $sql .= " AND i.sucursal_id = ?";
    $types .= 'i'; // 'i' para entero
    $params[] = $sucursal_id;
}

if (!empty($fecha_inicio)) {
    $sql .= " AND l.fechacreacion >= ?";
    $types .= 's'; // 's' para string (fecha)
    $params[] = $fecha_inicio;
}

if (!empty($fecha_fin)) {
    $sql .= " AND l.fechacreacion <= ?";
    $types .= 's';
    $params[] = $fecha_fin;
}

$sql .= " ORDER BY s.nombre, p.NombreComercial, l.fechacreacion DESC";

// --- PREPARAR Y EJECUTAR LA CONSULTA ---
$stmt = $conexion->prepare($sql);

if ($stmt === false) {
    die("Error al preparar la consulta: " . $conexion->error);
}

// Vincular parámetros si existen
if (!empty($types)) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();

// --- GENERAR LA SALIDA HTML PARA LA TABLA ---
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['NombreComercial']) . "</td>";
        echo "<td>" . htmlspecialchars($row['codigo_lote']) . "</td>";
        echo "<td>" . htmlspecialchars($row['fechacreacion_formateada']) . "</td>";
        echo "<td>" . htmlspecialchars($row['fechavencimiento_formateada']) . "</td>";
        echo "<td>" . htmlspecialchars($row['nombre_sucursal']) . "</td>";
        echo "<td>" . htmlspecialchars($row['stock_unidad_base']) . "</td>";
        echo "<td>" . htmlspecialchars($row['presentacion']) . "</td>";
        // Formateamos los costos como moneda (ej. Q 1,234.56)
        echo "<td>Q " . number_format($row['CostoUnidad'], 2) . "</td>";
        echo "<td>Q " . number_format($row['CostoTotal'], 2) . "</td>";
        echo "</tr>";
    }
} else {
    echo '<tr><td colspan="9" class="text-center">No se encontraron productos con los filtros seleccionados.</td></tr>';
}

// Cerrar recursos
$stmt->close();
$conexion->close();

?>