<?php
// export/exportar_excel.php

// Incluir la conexión a la base de datos
require_once '../config/db.php';

// --- RECOGER PARÁMETROS DE LA URL (GET) ---
$sucursal_id = isset($_GET['sucursal_id']) ? $_GET['sucursal_id'] : '';
$fecha_inicio = isset($_GET['fecha_inicio']) ? $_GET['fecha_inicio'] : '';
$fecha_fin = isset($_GET['fecha_fin']) ? $_GET['fecha_fin'] : '';

// --- DEFINIR HEADERS PARA FORZAR LA DESCARGA DEL ARCHIVO ---
$filename = "Inventario_Sufarma_" . date('Y-m-d') . ".xls";
header("Content-Type: application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=\"$filename\"");

// --- CONSTRUIR Y EJECUTAR LA MISMA CONSULTA SQL QUE EN AJAX ---
$sql = "
    SELECT 
        p.NombreComercial, p.NombreGenerico,
        p.CostoUnidad,
        l.codigo_lote,
        DATE_FORMAT(l.fechacreacion, '%Y-%m-%d') as fechacreacion,
        DATE_FORMAT(l.fechavencimiento, '%Y-%m-%d') as fechavencimiento,
        s.nombre as nombre_sucursal,
        i.stock_unidad_base,
        i.presentacion,
        (p.CostoUnidad * i.stock_unidad_base) AS CostoTotal,
        p.CodigoInterno, p.laboratorio
    FROM inventario i
    JOIN lote l ON i.lote_id = l.id
    JOIN productos p ON l.producto_id = p.id
    JOIN sucursales s ON i.sucursal_id = s.id
    WHERE 1=1
";

$params = [];
$types = '';

if (!empty($sucursal_id)) {
    $sql .= " AND i.sucursal_id = ?";
    $types .= 'i';
    $params[] = $sucursal_id;
}
if (!empty($fecha_inicio)) {
    $sql .= " AND l.fechacreacion >= ?";
    $types .= 's';
    $params[] = $fecha_inicio;
}
if (!empty($fecha_fin)) {
    $sql .= " AND l.fechacreacion <= ?";
    $types .= 's';
    $params[] = $fecha_fin;
}
$sql .= " ORDER BY s.nombre, p.NombreComercial, l.fechacreacion DESC";

$stmt = $conexion->prepare($sql);
if (!empty($types)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

// --- GENERAR EL CONTENIDO DEL EXCEL (TABLA HTML) ---
echo '<html xmlns:x="urn:schemas-microsoft-com:office:excel">';
echo '<head><meta charset="utf-8"></head>';
echo '<body>';
echo '<table border="1">';
// Encabezados de la tabla
echo '<thead><tr>
    <th>Codigo Interno</th>
    <th>Nombre Comercial</th>
    <th>Nombre Generico</th>
    <th>Laboratorio</th>
    <th>Lote</th>
    <th>Fecha Creacion</th>
    <th>Fecha Vencimiento</th>
    <th>Sucursal</th>
    <th>Stock Unidades</th>
    <th>Presentacion</th>
    <th>Costo Unidad</th>
    <th>Costo Total Inventario</th>
</tr></thead>';
echo '<tbody>';
// Datos
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['CodigoInterno']) . "</td>";
        echo "<td>" . htmlspecialchars($row['NombreComercial']) . "</td>";
        echo "<td>" . htmlspecialchars($row['NombreGenerico']) . "</td>";
        echo "<td>" . htmlspecialchars($row['laboratorio']) . "</td>";
        echo "<td>" . htmlspecialchars($row['codigo_lote']) . "</td>";
        echo "<td>" . htmlspecialchars($row['fechacreacion']) . "</td>";
        echo "<td>" . htmlspecialchars($row['fechavencimiento']) . "</td>";
        echo "<td>" . htmlspecialchars($row['nombre_sucursal']) . "</td>";
        echo "<td>" . htmlspecialchars($row['stock_unidad_base']) . "</td>";
        echo "<td>" . htmlspecialchars($row['presentacion']) . "</td>";
        // Para Excel, es mejor no poner el símbolo de moneda para facilitar cálculos posteriores
        echo "<td>" . $row['CostoUnidad'] . "</td>";
        echo "<td>" . $row['CostoTotal'] . "</td>";
        echo "</tr>";
    }
}
echo '</tbody></table>';
echo '</body></html>';

$stmt->close();
$conexion->close();
exit();
?>