<?php
// Incluir el archivo de conexión para poder consultar las sucursales
require_once 'config/db.php';

// Consulta para obtener las sucursales y llenar el filtro
$sucursales_result = $conexion->query("SELECT id, nombre FROM sucursales ORDER BY nombre ASC");
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inventario de Farmacia - Sufarma</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .container { margin-top: 2rem; }
        .card-header { background-color: #0d6efd; color: white; }
    </style>
</head>
<body>

<div class="container">
    <div class="card shadow-sm">
        <div class="card-header">
            <h3 class="mb-0">💊 Sistema de Inventario - Farmacia Sufarma</h3>
        </div>
        <div class="card-body">
            <form id="filtroForm" class="row g-3 align-items-end mb-4">
                <div class="col-md-4">
                    <label for="fecha_inicio" class="form-label">Fecha de Ingreso (Desde)</label>
                    <input type="date" class="form-control" id="fecha_inicio">
                </div>
                <div class="col-md-4">
                    <label for="fecha_fin" class="form-label">Fecha de Ingreso (Hasta)</label>
                    <input type="date" class="form-control" id="fecha_fin">
                </div>
                <div class="col-md-4">
                    <label for="sucursal_id" class="form-label">Sucursal</label>
                    <select class="form-select" id="sucursal_id">
                        <option value="">-- Todas las sucursales --</option>
                        <?php while($sucursal = $sucursales_result->fetch_assoc()): ?>
                            <option value="<?php echo $sucursal['id']; ?>"><?php echo htmlspecialchars($sucursal['nombre']); ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
            </form>

            <div class="d-flex justify-content-between mb-3">
                <button type="button" id="btnFiltrar" class="btn btn-primary">🔍 Aplicar Filtros</button>
                <a id="btnExportar" href="export/exportar_excel.php" class="btn btn-success">📊 Exportar a Excel</a>
            </div>

            <div class="table-responsive">
                <table class="table table-striped table-hover table-bordered">
                    <thead class="table-dark">
                        <tr>
                            <th>Producto (Comercial)</th>
                            <th>Lote</th>
                            <th>Fecha Creación</th>
                            <th>Fecha Vencimiento</th>
                            <th>Sucursal</th>
                            <th>Stock (Unidades)</th>
                            <th>Presentación</th>
                            <th>Costo Unitario</th>
                            <th>Costo Total Inventario</th>
                        </tr>
                    </thead>
                    <tbody id="tablaResultados">
                        </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
$(document).ready(function() {
    
    // --- FUNCIÓN PARA CARGAR EL INVENTARIO ---
    function cargarInventario() {
        const fecha_inicio = $('#fecha_inicio').val();
        const fecha_fin = $('#fecha_fin').val();
        const sucursal_id = $('#sucursal_id').val();

        // Petición AJAX al servidor
        $.ajax({
            url: 'ajax/filtrar_inventario.php',
            type: 'POST',
            data: {
                fecha_inicio: fecha_inicio,
                fecha_fin: fecha_fin,
                sucursal_id: sucursal_id
            },
            // Antes de enviar, muestra un indicador de carga (opcional)
            beforeSend: function() {
                $('#tablaResultados').html('<tr><td colspan="9" class="text-center">Cargando inventario...</td></tr>');
            },
            // Si la petición es exitosa
            success: function(response) {
                $('#tablaResultados').html(response);
            },
            // Si ocurre un error
            error: function() {
                $('#tablaResultados').html('<tr><td colspan="9" class="text-center text-danger">Error al cargar los datos. Intente de nuevo.</td></tr>');
            }
        });

        // Actualizar el enlace del botón de exportar
        actualizarEnlaceExportar();
    }

    // --- FUNCIÓN PARA ACTUALIZAR EL BOTÓN DE EXCEL ---
    function actualizarEnlaceExportar() {
        const fecha_inicio = $('#fecha_inicio').val();
        const fecha_fin = $('#fecha_fin').val();
        const sucursal_id = $('#sucursal_id').val();

        // Construir la URL con los parámetros del filtro
        let url = `export/exportar_excel.php?sucursal_id=${sucursal_id}&fecha_inicio=${fecha_inicio}&fecha_fin=${fecha_fin}`;
        $('#btnExportar').attr('href', url);
    }

    // --- EVENTO CLICK PARA EL BOTÓN DE FILTRAR ---
    $('#btnFiltrar').on('click', function() {
        cargarInventario();
    });

    // --- CARGA INICIAL DEL INVENTARIO ---
    // Carga todos los productos la primera vez que se abre la página
    cargarInventario();

});
</script>

</body>
</html>