<?php
// exportar_excel.php
require 'conexion.php';
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=reporte_ventas.xls");

$fecha_inicio = $_GET['fecha_inicio'] ?? '';
$fecha_fin = $_GET['fecha_fin'] ?? '';
$sucursal = $_GET['sucursal'] ?? '';

$query = "SELECT p.NombreComercial AS producto, dv.precio AS precio_venta, SUM(dv.cantidad_producto) AS cantidad_vendida, SUM(dv.precio * dv.cantidad_producto) AS subtotal FROM detalleventaproducto dv INNER JOIN productos p ON dv.producto_id = p.id INNER JOIN ventas v ON dv.venta_id = v.id";

$where = [];
if ($fecha_inicio && $fecha_fin) {
    $where[] = "v.fecha_y_hora BETWEEN '$fecha_inicio 00:00:00' AND '$fecha_fin 23:59:59'";
}
if ($sucursal) {
    $where[] = "v.sucursal_id = '$sucursal'";
}

if ($where) {
    $query .= " WHERE " . implode(" AND ", $where);
}
$query .= " GROUP BY p.NombreComercial, dv.precio ORDER BY cantidad_vendida DESC";

$result = $conn->query($query);
echo "Producto\tPrecio de Venta\tCantidad Vendida\tSub Total\n";
while ($row = $result->fetch_assoc()) {
    echo "{$row['producto']}\t{$row['precio_venta']}\t{$row['cantidad_vendida']}\t{$row['subtotal']}\n";
}
?>
