<!-- index.php -->
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Ventas</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
<div class="container mt-4">
    <h2 class="mb-3">Reporte de Productos Vendidos</h2>
    <div class="row">
        <div class="col-md-3">
            <label>Fecha Inicio:</label>
            <input type="date" id="fecha_inicio" class="form-control">
        </div>
        <div class="col-md-3">
            <label>Fecha Fin:</label>
            <input type="date" id="fecha_fin" class="form-control">
        </div>
        <div class="col-md-3">
            <label>Sucursal:</label>
            <select id="sucursal" class="form-control">
                <option value="">Todas</option>
                <?php
                require 'conexion.php';
                $result = $conn->query("SELECT id, nombre FROM sucursales");
                while ($row = $result->fetch_assoc()) {
                    echo "<option value='" . $row['id'] . "'>" . $row['nombre'] . "</option>";
                }
                ?>
            </select>
        </div>
        <div class="col-md-3 d-flex align-items-end">
            <button class="btn btn-primary" onclick="cargarVentas()">Filtrar</button>
            <button class="btn btn-success ms-2" onclick="exportarExcel()">Exportar a Excel</button>
        </div>
    </div>
    <br>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Producto</th>
                <th>Precio de Venta</th>
                <th>Cantidad Vendida</th>
                <th>Sub Total</th>
            </tr>
        </thead>
        <tbody id="tabla_ventas">
        </tbody>
    </table>
</div>
<script>
function cargarVentas() {
    let fecha_inicio = $('#fecha_inicio').val();
    let fecha_fin = $('#fecha_fin').val();
    let sucursal = $('#sucursal').val();
    
    $.ajax({
        url: 'obtener_ventas.php',
        type: 'POST',
        data: { fecha_inicio, fecha_fin, sucursal },
        success: function(response) {
            $('#tabla_ventas').html(response);
        }
    });
}

function exportarExcel() {
    let fecha_inicio = $('#fecha_inicio').val();
    let fecha_fin = $('#fecha_fin').val();
    let sucursal = $('#sucursal').val();
    
    window.location.href = 'exportar_excel.php?fecha_inicio=' + fecha_inicio + '&fecha_fin=' + fecha_fin + '&sucursal=' + sucursal;
}
</script>
</body>
</html>