<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Ventas Especiales - Sufarma</title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
</head>
<body>
<div class="container mt-5">
    <h1 class="mb-4">Ventas Especiales</h1>
    
    <!-- Formulario de filtros -->
    <form id="filterForm" class="form-inline mb-4">
        <div class="form-group mr-3">
            <label for="filterType" class="mr-2">Filtro por:</label>
            <select name="filter_type" id="filterType" class="form-control">
                <option value="day">Día</option>
                <option value="week">Semana</option>
                <option value="month">Mes</option>
                <option value="year">Año</option>
            </select>
        </div>
        <div class="form-group mr-3">
            <label for="filterDate" class="mr-2">Fecha:</label>
            <input type="date" name="date" id="filterDate" class="form-control" value="<?php echo date('Y-m-d'); ?>">
        </div>
        <div class="form-group mr-3">
            <label for="sucursal" class="mr-2">Sucursal:</label>
            <select name="sucursal_id" id="sucursal" class="form-control">
                <option value="">Todas</option>
                <!-- Se llenará mediante Ajax -->
            </select>
        </div>
        <button type="submit" class="btn btn-primary">Filtrar</button>
    </form>
    
    <!-- Tabla para mostrar las ventas -->
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Fecha y Hora</th>
                <th>Descripción</th>
                <th>Precio</th>
                <th>Sucursal</th>
            </tr>
        </thead>
        <tbody id="salesData">
            <!-- Los datos se cargarán aquí -->
        </tbody>
    </table>
</div>

<script>
$(document).ready(function(){
    // Cargar las sucursales en el select
    $.ajax({
        url: 'get_branches.php',
        method: 'GET',
        dataType: 'json',
        success: function(data){
            $.each(data, function(index, branch){
                $('#sucursal').append('<option value="'+branch.id+'">'+branch.nombre+'</option>');
            });
        }
    });
    
    // Evento para el formulario de filtros
    $('#filterForm').on('submit', function(e){
        e.preventDefault();
        loadSales();
    });
    
    // Función para cargar las ventas usando Ajax
    function loadSales(){
        var formData = $('#filterForm').serialize();
        $.ajax({
            url: 'get_sales.php',
            method: 'GET',
            data: formData,
            dataType: 'json',
            success: function(data){
                var rows = '';
                if(data.length > 0){
                    $.each(data, function(index, sale){
                        rows += '<tr>';
                        rows += '<td>'+sale.id+'</td>';
                        rows += '<td>'+sale.fecha_y_hora+'</td>';
                        rows += '<td>'+sale.descripcion+'</td>';
                        rows += '<td>'+sale.precio+'</td>';
                        rows += '<td>'+sale.sucursal+'</td>';
                        rows += '</tr>';
                    });
                } else {
                    rows = '<tr><td colspan="5" class="text-center">No se encontraron ventas</td></tr>';
                }
                $('#salesData').html(rows);
            }
        });
    }
    
    // Cargar datos inicialmente
    loadSales();
});
</script>
</body>
</html>
