<?php
// get_sales.php

// Configuración de la conexión a la base de datos
$host   = 'localhost';
$dbname = 'farmacia_sufarma2025';  // Reemplaza por el nombre de tu base de datos
$user   = 'farmacia_onlydi2025';           // Reemplaza por tu usuario de BD
$pass   = '1corintios13';        // Reemplaza por tu contraseña

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e){
    die("Error de conexión: " . $e->getMessage());
}

// Obtener parámetros del formulario
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : null;
$end_date   = isset($_GET['end_date']) ? $_GET['end_date'] : null;
$group_by   = isset($_GET['group_by']) ? $_GET['group_by'] : 'day';

// Construir la condición de fechas
$where = "";
$params = array();
if ($start_date && $end_date) {
    $where = "WHERE v.fecha_y_hora BETWEEN :start_date AND :end_date";
    $params[':start_date'] = $start_date . ' 00:00:00';
    $params[':end_date']   = $end_date . ' 23:59:59';
}

// Según el tipo de agrupación, definimos el campo que se mostrará como "Periodo"
switch ($group_by) {
    case 'day':
        $group_by_field = "DATE(v.fecha_y_hora)";
        break;
    case 'week':
        // Se concatena el año y la semana para identificar el período
        $group_by_field = "CONCAT(YEAR(v.fecha_y_hora), '-W', WEEK(v.fecha_y_hora))";
        break;
    case 'month':
        $group_by_field = "DATE_FORMAT(v.fecha_y_hora, '%Y-%m')";
        break;
    case 'year':
        $group_by_field = "YEAR(v.fecha_y_hora)";
        break;
    default:
        $group_by_field = "DATE(v.fecha_y_hora)";
        break;
}

// Consulta SQL que obtiene, por cada sucursal y periodo, la cantidad de ventas, montos y ganancias
$sql = "SELECT 
            s.nombre AS Sucursal,
            $group_by_field AS Periodo,
            COUNT(v.id) AS TotalVentas,
            SUM(v.total) AS MontoTotalVentas,
            SUM(dc.sale_cost) AS CostoTotal,
            (SUM(v.total) - SUM(dc.sale_cost)) AS GananciaBruta,
            (SUM(v.total) - SUM(dc.sale_cost)) * 0.12 AS Impuesto12,
            (SUM(v.total) - SUM(dc.sale_cost)) * 0.88 AS GananciaNeta
        FROM ventas v
        JOIN sucursales s ON s.id = v.sucursal_id
        LEFT JOIN (
            SELECT 
                dv.venta_id, 
                SUM(dv.cantidad * p.CostoUnidad) AS sale_cost
            FROM detalle_ventas dv
            JOIN productos p ON p.id = dv.producto_id
            GROUP BY dv.venta_id
        ) dc ON dc.venta_id = v.id
        $where
        GROUP BY s.id, Periodo
        ORDER BY s.nombre, Periodo";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Enviar el resultado en formato JSON
header('Content-Type: application/json');
echo json_encode($results);
