<?php
// index.php
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Reporte de Ventas por Sucursal</title>
  <!-- Bootstrap CSS -->
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
  <!-- Bootstrap JS -->
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</head>
<body>
  <div class="container">
    <h1 class="mt-5">Reporte de Ventas por Sucursal</h1>
    <form id="filterForm" class="form-inline mt-3 mb-3">
      <div class="form-group mr-2">
        <label for="start_date" class="mr-2">Fecha Inicio:</label>
        <input type="date" id="start_date" name="start_date" class="form-control">
      </div>
      <div class="form-group mr-2">
        <label for="end_date" class="mr-2">Fecha Fin:</label>
        <input type="date" id="end_date" name="end_date" class="form-control">
      </div>
      <div class="form-group mr-2">
        <label for="group_by" class="mr-2">Agrupar Por:</label>
        <select name="group_by" id="group_by" class="form-control">
          <option value="day">Día</option>
          <option value="week">Semana</option>
          <option value="month">Mes</option>
          <option value="year">Año</option>
        </select>
      </div>
      <button type="submit" class="btn btn-primary">Filtrar</button>
    </form>

    <div id="results">
      <table class="table table-bordered">
        <thead>
          <tr>
            <th>Sucursal</th>
            <th>Periodo</th>
            <th>Total Ventas</th>
            <th>Monto Total Ventas</th>
            <th>Costo Total</th>
            <th>Ganancia Bruta</th>
            <th>Impuesto (12%)</th>
            <th>Ganancia Neta</th>
          </tr>
        </thead>
        <tbody id="resultsBody">
          <!-- Aquí se mostrarán los resultados -->
        </tbody>
      </table>
    </div>
  </div>

  <script>
  $(document).ready(function(){
      $('#filterForm').on('submit', function(e){
          e.preventDefault();
          $.ajax({
              url: 'get_sales.php',
              type: 'GET',
              data: $(this).serialize(),
              dataType: 'json',
              success: function(data){
                  var html = '';
                  if(data.length > 0){
                      $.each(data, function(index, row){
                          html += '<tr>';
                          html += '<td>' + row.Sucursal + '</td>';
                          html += '<td>' + row.Periodo + '</td>';
                          html += '<td>' + row.TotalVentas + '</td>';
                          html += '<td>' + parseFloat(row.MontoTotalVentas).toFixed(2) + '</td>';
                          html += '<td>' + parseFloat(row.CostoTotal).toFixed(2) + '</td>';
                          html += '<td>' + parseFloat(row.GananciaBruta).toFixed(2) + '</td>';
                          html += '<td>' + parseFloat(row.Impuesto12).toFixed(2) + '</td>';
                          html += '<td>' + parseFloat(row.GananciaNeta).toFixed(2) + '</td>';
                          html += '</tr>';
                      });
                  } else {
                      html = '<tr><td colspan="8" class="text-center">No hay datos para el rango seleccionado</td></tr>';
                  }
                  $('#resultsBody').html(html);
              },
              error: function(xhr, status, error){
                  console.log(error);
              }
          });
      });
  });
  </script>
</body>
</html>
