<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../db_connection.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? null;
    $field = $_POST['field'] ?? null;
    $value = $_POST['value'] ?? null;

    if (empty($id) || empty($field)) {
        echo json_encode(['success' => false, 'message' => 'Datos incompletos.']);
        exit;
    }

    // Lista blanca de campos editables para seguridad (con todos los campos solicitados)
    $allowed_fields = [
        'CodigoInterno',
        'CodigoBarra',
        'NombreComercial',
        'NombreGenerico',
        'laboratorio',
        'CostoUnidad',
        'CostoBlister',
        'CostoMayor',
        'CostoMixto',
        'PrecioVentaUnidad',
        'PrecioVentaBlister',
        'PrecioVentaMayor',
        'PrecioVentaMixto',
        'FechaIngreso',
        'FechaVencimiento',
        'existencia',
        'exento_iva' // Añadido para poder editarlo
    ];

    if (!in_array($field, $allowed_fields)) {
        echo json_encode(['success' => false, 'message' => 'Campo no permitido para edición.']);
        exit;
    }

    $query = "UPDATE productos SET `$field` = ? WHERE id = ?";
    $stmt = $conn->prepare($query);
    
    // Asumimos string por defecto para todos los campos para simplificar
    // MySQL usualmente maneja la coerción de tipos correctamente en este contexto.
    $stmt->bind_param('si', $value, $id);

    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Producto actualizado.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error al actualizar: ' . $stmt->error]);
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Método no permitido.']);
}
?>