<!-- Titulo y Botones de Acción -->
<div class="d-flex justify-content-between align-items-center mb-3">
    <h2>Reporte General de Inventario</h2>
    <button type="button" class="btn btn-success" id="export-inventory-btn">
        <i class="fas fa-file-excel"></i> Exportar a Excel
    </button>
</div>

<!-- Filtros de Reporte -->
<div class="card mb-4">
    <div class="card-header">
        <i class="fas fa-search"></i> Filtros de Reporte
    </div>
    <div class="card-body">
        <form id="inventory-report-filter-form">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="report-search-term" class="form-label">Buscar Producto:</label>
                    <input type="text" id="report-search-term" class="form-control" placeholder="Código, Nombre Comercial, Genérico...">
                </div>
                <div class="col-md-6 mb-3">
                    <label for="report-laboratory-filter" class="form-label">Filtrar por Laboratorio:</label>
                    <input type="text" id="report-laboratory-filter" class="form-control" placeholder="Escribe el nombre del laboratorio...">
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="report-branch-filter" class="form-label">Filtrar por Sucursal:</label>
                    <select id="report-branch-filter" class="form-select">
                        <option value="">Todas las Sucursales</option>
                        <!-- Options will be dynamically loaded by JS -->
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="report-presentation-filter" class="form-label">Filtrar por Presentación:</label>
                    <select id="report-presentation-filter" class="form-select">
                        <option value="">Todas las Presentaciones</option>
                        <option value="UNIDAD">UNIDAD</option>
                        <option value="BLISTER">BLISTER</option>
                        <option value="CAJA">CAJA</option>
                        <option value="BOLSA">BOLSA</option>
                        <option value="BOTE">BOTE</option>
                        <option value="FARDO">FARDO</option>
                        <option value="GALON">GALON</option>
                    </select>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Tabla de Reporte de Inventario -->
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped table-hover table-sm">
                <thead>
                    <tr>
                        <th>Código Producto</th>
                        <th>Nombre Comercial</th>
                        <th>Laboratorio</th>
                        <th>Presentación</th>
                        <th>Cantidad en SANFE (ID 3)</th>
                        <th>Cantidad en CHIQUI (ID 5)</th>
                        <th>Cantidad en CENTRO (ID 2)</th>
                        <th>Cantidad en ZONA1 (ID 4)</th>
                        <th>Fecha y Hora Actualización</th>
                    </tr>
                </thead>
                <tbody id="inventory-report-table-body">
                    <!-- Los datos del reporte se cargarán aquí vía AJAX -->
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer d-flex justify-content-between align-items-center">
        <div id="inventory-report-table-info"></div>
        <nav id="inventory-report-pagination"></nav>
    </div>
</div>