<?php
// actualizar_exento_iva.php
include 'db_connection.php';

header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);

$id = $input['id'] ?? null;
$exento_iva = $input['exento_iva'] ?? null;

if ($id === null || $exento_iva === null) {
    echo json_encode(['success' => false, 'message' => 'Datos incompletos.']);
    exit;
}

$exento_iva_val = $exento_iva ? 1 : 0;

$sql = "UPDATE productos SET exento_iva = ? WHERE id = ?";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo json_encode(['success' => false, 'message' => 'Error al preparar la consulta: ' . $conn->error]);
    exit;
}

$stmt->bind_param('ii', $exento_iva_val, $id);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Producto actualizado correctamente.']);
} else {
    echo json_encode(['success' => false, 'message' => 'Error al actualizar el producto: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
?>