document.addEventListener('DOMContentLoaded', function() {
    // Manejar la edición en línea de precios
    document.querySelectorAll('.editable').forEach(function(element) {
        element.addEventListener('click', function() {
            const currentValue = this.textContent.replace('Q ', '');
            const input = document.createElement('input');
            input.type = 'text';
            input.value = currentValue;
            input.className = 'form-control form-control-sm';
            
            this.textContent = '';
            this.appendChild(input);
            input.focus();

            input.addEventListener('blur', handlePriceUpdate);
            input.addEventListener('keypress', function(e) {
                if (e.key === 'Enter') {
                    input.blur();
                }
            });
        });
    });

    function handlePriceUpdate(e) {
        const input = e.target;
        const container = input.parentElement;
        const newValue = input.value;
        const field = container.dataset.field;
        const row = container.closest('tr');
        const id = row.dataset.id;

        // Validar que sea un número válido
        if (isNaN(newValue) || newValue.trim() === '') {
            alert('Por favor ingrese un valor numérico válido');
            container.textContent = 'Q ' + input.defaultValue;
            return;
        }

        // Enviar actualización al servidor
        fetch('actualizar_producto.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                id: id,
                field: field,
                value: newValue
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                container.textContent = 'Q ' + newValue;
            } else {
                alert('Error al actualizar el precio: ' + data.message);
                container.textContent = 'Q ' + input.defaultValue;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error al actualizar el precio');
            container.textContent = 'Q ' + input.defaultValue;
        });
    }
});