<?php
include 'db_connection.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

// Validar campos requeridos (CodigoBarra es opcional, así que no se añade aquí)
if (!isset($data['NombreComercial']) || !isset($data['NombreGenerico']) || !isset($data['laboratorio'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Nombre Comercial, Nombre Genérico y Laboratorio son requeridos.']);
    exit;
}

// Obtener la primera letra del nombre comercial
$firstLetter = strtolower(substr($data['NombreComercial'], 0, 1));

// Buscar el último código con esa letra
$sql_select_code = "SELECT CodigoInterno FROM productos WHERE CodigoInterno LIKE ? ORDER BY CodigoInterno DESC LIMIT 1";
$stmt_select_code = $conn->prepare($sql_select_code);
$pattern = $firstLetter . '%';
$stmt_select_code->bind_param('s', $pattern);
$stmt_select_code->execute();
$result_code = $stmt_select_code->get_result();

// Generar nuevo código
$newCode = '';
if ($row_code = $result_code->fetch_assoc()) {
    $lastCode = $row_code['CodigoInterno'];
    $numPart = intval(substr($lastCode, 1));
    $newCode = $firstLetter . str_pad($numPart + 1, 4, '0', STR_PAD_LEFT);
} else {
    $newCode = $firstLetter . '0001';
}
$stmt_select_code->close();

// Preparar la consulta de inserción
$sql_insert = "INSERT INTO productos (CodigoInterno, CodigoBarra, NombreComercial, NombreGenerico, laboratorio,
        PrecioVentaUnidad, PrecioVentaBlister, PrecioVentaMayor, PrecioVentaMixto,
        CostoUnidad, CostoBlister, CostoMayor, CostoMixto, FechaIngreso, FechaVencimiento, existencia, exento_iva)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, CURDATE(), ?, ?, ?)";

$stmt_insert = $conn->prepare($sql_insert);

// Obtener CodigoBarra (puede ser nulo o vacío si no se envía)
$codigoBarra = isset($data['CodigoBarra']) ? $data['CodigoBarra'] : null;

// Establecer valores por defecto para los campos numéricos
$precioVentaUnidad = isset($data['PrecioVentaUnidad']) ? floatval($data['PrecioVentaUnidad']) : 0;
$precioVentaBlister = isset($data['PrecioVentaBlister']) ? floatval($data['PrecioVentaBlister']) : 0;
$precioVentaMayor = isset($data['PrecioVentaMayor']) ? floatval($data['PrecioVentaMayor']) : 0;
$precioVentaMixto = isset($data['PrecioVentaMixto']) ? floatval($data['PrecioVentaMixto']) : 0;
$costoUnidad = isset($data['CostoUnidad']) ? floatval($data['CostoUnidad']) : 0;
$costoBlister = isset($data['CostoBlister']) ? floatval($data['CostoBlister']) : 0;
$costoMayor = isset($data['CostoMayor']) ? floatval($data['CostoMayor']) : 0;
$costoMixto = isset($data['CostoMixto']) ? floatval($data['CostoMixto']) : 0;
$existencia = isset($data['existencia']) ? intval($data['existencia']) : 0;
$fechaVencimiento = isset($data['FechaVencimiento']) ? $data['FechaVencimiento'] : null;
$exento_iva = isset($data['exento_iva']) && $data['exento_iva'] ? 1 : 0;


$stmt_insert->bind_param('sssssddddddddsii',
    $newCode,
    $codigoBarra, 
    $data['NombreComercial'],
    $data['NombreGenerico'],
    $data['laboratorio'],
    $precioVentaUnidad,
    $precioVentaBlister,
    $precioVentaMayor,
    $precioVentaMixto,
    $costoUnidad,
    $costoBlister,
    $costoMayor,
    $costoMixto,
    $fechaVencimiento,
    $existencia,
    $exento_iva
);

if ($stmt_insert->execute()) {
    echo json_encode([
        'success' => true,
        'message' => 'Producto agregado exitosamente',
        'codigoInterno' => $newCode
    ]);
} else {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error al agregar el producto: ' . $stmt_insert->error]);
}

$stmt_insert->close();
$conn->close();
?>