<?php
require 'db.php';
header('Content-Type: application/json');

try {
    // --- 1. Obtener la lista de todas las sucursales (para las columnas) ---
    $sucursales_stmt = $pdo->query("SELECT nombre FROM sucursales ORDER BY nombre");
    $sucursales_list = $sucursales_stmt->fetchAll(PDO::FETCH_COLUMN);

    // --- 2. Obtener los datos (como antes) ---
    $fecha_inicio = $_GET['fecha_inicio'] ?? '1900-01-01';
    $fecha_fin = $_GET['fecha_fin'] ?? '2999-12-31';
    if (empty($fecha_inicio)) $fecha_inicio = '1900-01-01';
    if (empty($fecha_fin)) $fecha_fin = '2999-12-31';

    // Añadimos l.id (lote_id) para usarlo como clave única de agrupación
    $sql = "
        SELECT
            l.id AS lote_id, -- Clave única para agrupar
            s.nombre AS nombre_sucursal,
            p.CodigoInterno,
            p.NombreComercial,
            p.laboratorio,
            l.codigo_lote,
            l.sefactura,
            DATE(l.fechacreacion) AS fechacreacion,
            i.stock_unidad_base,
            i.presentacion,
            p.CostoUnidad,
            p.CostoUnidadSinIva
        FROM
            inventario AS i
        JOIN
            lote AS l ON i.lote_id = l.id
        JOIN
            productos AS p ON l.producto_id = p.id
        JOIN
            sucursales AS s ON i.sucursal_id = s.id
        WHERE
            i.stock_unidad_base > 0
            AND DATE(l.fechacreacion) BETWEEN ? AND ?
        ORDER BY
            p.NombreComercial, l.codigo_lote
    ";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$fecha_inicio, $fecha_fin]);
    $resultados = $stmt->fetchAll();

    // --- 3. Pivotar los datos en PHP ---
    $pivoted_data = [];

    foreach ($resultados as $row) {
        $lote_id = $row['lote_id'];

        // Si es la primera vez que vemos este lote, creamos la entrada
        if (!isset($pivoted_data[$lote_id])) {
            $pivoted_data[$lote_id] = [
                'CodigoInterno'     => $row['CodigoInterno'],
                'NombreComercial'   => $row['NombreComercial'],
                'laboratorio'       => $row['laboratorio'],
                'codigo_lote'       => $row['codigo_lote'],
                'sefactura'         => $row['sefactura'],
                'sefactura_texto'   => ($row['sefactura'] == 1) ? 'Sí' : 'No',
                'fechacreacion'     => $row['fechacreacion'],
                'presentacion'      => $row['presentacion'],
                'CostoUnidad'       => $row['CostoUnidad'],
                'CostoUnidadSinIva' => $row['CostoUnidadSinIva'],
                'StockTotal'        => 0 // Inicializar el total
            ];
            
            // Inicializar el stock de TODAS las sucursales a 0 para esta fila
            foreach ($sucursales_list as $sucursal_nombre) {
                $pivoted_data[$lote_id][$sucursal_nombre] = 0;
            }
        }

        // Asignar el stock a la sucursal correcta y sumar al total
        $sucursal_actual = $row['nombre_sucursal'];
        $stock_actual = (int)$row['stock_unidad_base'];
        
        $pivoted_data[$lote_id][$sucursal_actual] = $stock_actual;
        $pivoted_data[$lote_id]['StockTotal'] += $stock_actual;
    }

    // Devolver los nombres de las sucursales (para las cabeceras) y los datos pivotados
    echo json_encode([
        'success' => true, 
        'sucursales' => $sucursales_list, // Lista de nombres de sucursales
        'data' => array_values($pivoted_data) // Los datos procesados
    ]);

} catch (\PDOException $e) {
    http_response_code(500); 
    echo json_encode(['success' => false, 'message' => $e->getMessage(), 'sucursales' => [], 'data' => []]);
}
?>