<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Traslados</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <header>
        <h1>Módulo de Traslados</h1>
    </header>
    <main>
        <h2>Nuevo Traslado entre Sucursales</h2>
        <form id="transfer-form">
            <div class="form-row">
                <div class="form-group">
                    <label for="sucursal-origen">Sucursal Origen:</label>
                    <select id="sucursal-origen" name="sucursal_origen" required></select>
                </div>
                <div class="form-group">
                    <label for="sucursal-destino">Sucursal Destino:</label>
                    <select id="sucursal-destino" name="sucursal_destino" required></select>
                </div>
            </div>

            <hr>

            <h3>Añadir Productos al Traslado</h3>
            <div class="form-row">
                <div class="form-group">
                    <label for="producto-search">Buscar Producto:</label>
                    <input type="text" id="producto-search" placeholder="Buscar por nombre o código">
                    <div id="producto-suggestions"></div>
                </div>
            </div>

            <h3>Productos a Trasladar</h3>
            <table id="transfer-products-table">
                <thead>
                    <tr>
                        <th>Producto</th>
                        <th>Lote</th>
                        <th>Stock Disponible</th>
                        <th>Cantidad a Trasladar</th>
                        <th>Acción</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Filas de productos se añadirán aquí dinámicamente -->
                </tbody>
            </table>

            <div class="form-group">
                <label for="observaciones">Observaciones:</label>
                <textarea id="observaciones" name="observaciones" rows="3"></textarea>
            </div>

            <button type="submit" class="btn">Realizar Traslado</button>
        </form>
    </main>
    <script src="assets/js/transfer.js"></script>
</body>
</html>
