<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../db_connection.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener datos del POST (con los nombres de campo correctos)
    $nombreComercial = $_POST['NombreComercial'] ?? null;
    $nombreGenerico = $_POST['NombreGenerico'] ?? null;
    $codigoInterno = $_POST['CodigoInterno'] ?? null;
    $codigoBarra = $_POST['CodigoBarra'] ?? null;
    $laboratorio = $_POST['laboratorio'] ?? null;
    $existencia = $_POST['existencia'] ?? 0;

    // Validación simple
    if (empty($nombreComercial)) {
        echo json_encode(['success' => false, 'message' => 'El nombre comercial es obligatorio.']);
        exit;
    }

    $fechaVencimiento = $_POST['FechaVencimiento'] ?? date('Y-m-d', strtotime('+1 year'));

    $query = "INSERT INTO productos (NombreComercial, NombreGenerico, CodigoInterno, CodigoBarra, laboratorio, existencia, FechaVencimiento) VALUES (?, ?, ?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($query);
    $stmt->bind_param('sssssis', 
        $nombreComercial, 
        $nombreGenerico, 
        $codigoInterno, 
        $codigoBarra, 
        $laboratorio, 
        $existencia,
        $fechaVencimiento
    );

    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Producto agregado exitosamente.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error al agregar el producto: ' . $stmt->error]);
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Método no permitido.']);
}
?>