<?php
header('Content-Type: application/json');
require_once 'config.php';

$respuesta = ['status' => 'error', 'message' => 'Datos inválidos.'];

if (isset($_POST['traslado_id'], $_POST['usuario_recibe_id'], $_POST['nuevo_estado'])) {

    $traslado_id = filter_var($_POST['traslado_id'], FILTER_VALIDATE_INT);
    $usuario_recibe_id = filter_var($_POST['usuario_recibe_id'], FILTER_VALIDATE_INT);
    $nuevo_estado = $_POST['nuevo_estado']; // 'completado' o 'cancelado'

    // Validar que el estado sea uno de los permitidos
    if ($nuevo_estado != 'completado' && $nuevo_estado != 'cancelado') {
        $respuesta['message'] = 'Estado no válido.';
        echo json_encode($respuesta);
        exit;
    }

    if ($traslado_id && $usuario_recibe_id) {
        
        // Si el estado es 'completado', ponemos la fecha de recepción.
        // Si es 'cancelado', la dejamos en NULL.
        $fecha_recepcion = ($nuevo_estado == 'completado') ? date('Y-m-d H:i:s') : null;

        try {
            // Actualizamos el traslado
            // 1. Cambiamos el estado
            // 2. Asignamos el ID del usuario que REALMENTE recibió
            // 3. Ponemos la fecha de recepción
            $sql = "UPDATE traslados SET 
                        estado = ?, 
                        usuario_receptor_id = ?, 
                        fecha_recepcion = ? 
                    WHERE id = ? AND sucursal_destino = ?"; // Doble chequeo de seguridad
            
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $nuevo_estado, 
                $usuario_recibe_id, 
                $fecha_recepcion, 
                $traslado_id,
                ID_SUCURSAL_ACTUAL // Solo podemos aceptar traslados para nuestra sucursal
            ]);

            if ($stmt->rowCount() > 0) {
                // Faltaría la lógica de INVENTARIO aquí,
                // pero por ahora solo cambiamos el estado.
                
                $respuesta['status'] = 'success';
                $respuesta['message'] = '¡Estado actualizado a ' . $nuevo_estado . '!';
            } else {
                $respuesta['message'] = 'No se pudo actualizar el traslado (quizás ya estaba procesado o no es para esta sucursal).';
            }

        } catch (PDOException $e) {
            $respuesta['message'] = 'Error de base de datos: ' . $e->getMessage();
        }
    }
}

echo json_encode($respuesta);
?>