<?php
require_once 'config.php';

// =============================================
//          CONSULTA SQL MODIFICADA
// =============================================
// 1. Añadimos un LEFT JOIN a 'lote' (alias 'l') para obtener 'l.sefactura'.
// 2. Añadimos un LEFT JOIN a 'usuarios' (alias 'u_entrega') para obtener el nombre del que entrega.
// 3. Renombramos el JOIN original de 'usuarios' a 'u_recibe'.
$sql = "SELECT 
            p.NombreComercial, 
            p.laboratorio, 
            i.cantidad_ingresada, 
            i.presentacion_ingresada, 
            i.fecha_ingreso, 
            i.fecha_vencimiento_ingreso,
            u_recibe.nombre AS usuario_recibe,
            u_entrega.nombre AS usuario_entrega,
            l.sefactura
        FROM ingresos_sucursal AS i
        JOIN productos AS p ON i.producto_id = p.id
        JOIN usuarios AS u_recibe ON i.usuario_recibe_id = u_recibe.id
        LEFT JOIN usuarios AS u_entrega ON i.usuario_entrega_id = u_entrega.id
        LEFT JOIN lote AS l ON i.lote_id = l.id
        WHERE i.sucursal_id = ?
        ORDER BY i.fecha_ingreso DESC
        LIMIT 10";

try {
    $stmt = $pdo->prepare($sql);
    $stmt->execute([ID_SUCURSAL_ACTUAL]);
    $ingresos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($ingresos) {
        $html = '';
        foreach ($ingresos as $ingreso) {
            // Formateamos las fechas para mejor legibilidad
            $fecha_ing = date('d/m/Y H:i A', strtotime($ingreso['fecha_ingreso']));
            $fecha_venc = date('d/m/Y', strtotime($ingreso['fecha_vencimiento_ingreso']));

            // =============================================
            //          NUEVAS LÍNEAS AÑADIDAS
            // =============================================
            // 1. Convertimos el 1/0 de 'sefactura' en "SI" o "NO" (con un estilo)
            $facturable_texto = $ingreso['sefactura'] == 1 
                ? "<span class='badge bg-success'>SI</span>" 
                : "<span class='badge bg-secondary'>NO</span>";
            
            // 2. Manejamos si el usuario que entrega es nulo (mostramos 'N/A')
            $usuario_entrega = $ingreso['usuario_entrega'] ? $ingreso['usuario_entrega'] : 'N/A';
            

            // =============================================
            //          HTML DE LA FILA MODIFICADO
            // =============================================
            $html .= "<tr>";
            $html .= "<td><strong>{$ingreso['NombreComercial']}</strong><br><small class='text-muted'>{$ingreso['laboratorio']}</small></td>";
            $html .= "<td>{$ingreso['cantidad_ingresada']}</td>";
            $html .= "<td>{$ingreso['presentacion_ingresada']}</td>";
            $html .= "<td>{$fecha_venc}</td>";
            $html .= "<td>{$facturable_texto}</td>";     // <-- NUEVA COLUMNA
            $html .= "<td>{$fecha_ing}</td>";
            $html .= "<td>{$usuario_entrega}</td>";      // <-- NUEVA COLUMNA
            $html .= "<td>{$ingreso['usuario_recibe']}</td>";
            $html .= "</tr>";
        }
        echo $html;
    } else {
        // Colspan actualizado a 8
        echo "<tr><td colspan='8' class='text-center'>No hay ingresos registrados para esta sucursal.</td></tr>";
    }

} catch (PDOException $e) {
    // Colspan actualizado a 8
    echo "<tr><td colspan='8' class='text-center text-danger'>Error de base de datos: " . $e->getMessage() . "</td></tr>";
}
?>