<?php
include 'db_connection.php';

header('Content-Type: application/json');

// Verificar que sea una petición POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit;
}

// Obtener y validar los datos
$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['id']) || !isset($data['field']) || !isset($data['value'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Datos incompletos']);
    exit;
}

$id = intval($data['id']);
$field = $data['field'];
$value = $data['value'];

// Lista de campos permitidos para actualizar
$allowed_fields = [
    'CodigoInterno',
    'CodigoBarra',
    'NombreComercial',
    'NombreGenerico',
    'laboratorio',
    'PrecioVentaUnidad',
    'PrecioVentaBlister',
    'PrecioVentaMayor',
    'PrecioVentaMixto',
    'CostoUnidad',
    'CostoBlister',
    'CostoMayor',
    'CostoMixto',
    'FechaIngreso',
    'FechaVencimiento',
    'existencia'
];

// Verificar que el campo sea válido
if (!in_array($field, $allowed_fields)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Campo no válido']);
    exit;
}

// Preparar y ejecutar la consulta
// Manejar campos de fecha y existencia de manera diferente
if ($field === 'fechaingreso' || $field === 'fechavencimiento') {
    // Validar formato de fecha
    $date = date('Y-m-d', strtotime($value));
    if ($date === false) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Formato de fecha inválido']);
        exit;
    }
    $sql = "UPDATE productos SET $field = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('si', $date, $id);
} elseif ($field === 'existencia') {
    // Validar que sea un número entero positivo
    $value = intval($value);
    if ($value < 0) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'La existencia no puede ser negativa']);
        exit;
    }
    $sql = "UPDATE productos SET $field = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('ii', $value, $id);
} else {
    $sql = "UPDATE productos SET $field = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('di', $value, $id);
}

if (!$stmt) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error en la preparación de la consulta']);
    exit;
}

// Determinar el tipo de dato para bind_param
$type = 'si'; // string por defecto + integer para el id
if (strpos($field, 'Precio') === 0 || strpos($field, 'Costo') === 0) {
    $type = 'di'; // double para precios y costos
}

$stmt->bind_param($type, $value, $id);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Actualización exitosa']);
} else {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error al actualizar: ' . $stmt->error]);
}

$stmt->close();
$conn->close();